require 'g_level'
g_level.reset()

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 1
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 2
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 = dummy, for menus

--The blackkened layer.
local scale = 1000
lua_init_texture("menu_background", "data/images/effects/black.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua:create_sprite("background", ST_TEXTURED,"menu_background",      0, 0) 
lua:sprite_shape("background",ST_TEXTURED,                          scale * 16.0, scale * 16.0)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,           1.0, 1.0, 1.0, 1.0)
lua:sprite_color("background",                                       1.0,1.0,1.0,1.0)
g_level.upload("background",1)   --number of layers is 5, thus the index of the upperst layer is 4
--text
lua:create_text("tuomo","comic_sans",0.0,0.0,0.1,0.7) --name, font, x,y, delay, scale
lua:text_color("tuomo",1.0,1.0,1.0,1.0)  --name, r,g,b,a
lua:add_text("tuomo", "Hahaa,")
lua:add_text("tuomo", "You thought you had options!")
g_level.upload("tuomo",2)
lua:gameobject_remove_from_temp_list( "tuomo" )
--text

fade_in(2)
timer(10,"data/scripts/lvl_menu.lua") -- time, script

lua:set_game_state(GS_FREEZE) -- sets the game state to menu. thus you are able to use the menu commands

